/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mapping.dip;

import fr.gouv.culture.archivesdefrance.seda.v2.CodeKeywordType;
import fr.gouv.culture.archivesdefrance.seda.v2.CodeType;
import fr.gouv.culture.archivesdefrance.seda.v2.CoverageType;
import fr.gouv.culture.archivesdefrance.seda.v2.CustodialHistoryType;
import fr.gouv.culture.archivesdefrance.seda.v2.DescriptiveMetadataContentType;
import fr.gouv.culture.archivesdefrance.seda.v2.DetachedSigningRoleType;
import fr.gouv.culture.archivesdefrance.seda.v2.EventType;
import fr.gouv.culture.archivesdefrance.seda.v2.ExtendedType;
import fr.gouv.culture.archivesdefrance.seda.v2.IdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2.KeyType;
import fr.gouv.culture.archivesdefrance.seda.v2.LevelType;
import fr.gouv.culture.archivesdefrance.seda.v2.LinkingAgentIdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2.ManagementHistoryDataType;
import fr.gouv.culture.archivesdefrance.seda.v2.ManagementHistoryType;
import fr.gouv.culture.archivesdefrance.seda.v2.MessageDigestBinaryObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.OrganizationDescriptiveMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v2.ReferencedObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.SignatureDescriptionType;
import fr.gouv.culture.archivesdefrance.seda.v2.SignatureType;
import fr.gouv.culture.archivesdefrance.seda.v2.SigningInformationType;
import fr.gouv.culture.archivesdefrance.seda.v2.TextType;
import fr.gouv.culture.archivesdefrance.seda.v2.TimestampingInformationType;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.ExportException;
import fr.gouv.vitam.common.mapping.dip.CustodialHistoryMapper;
import fr.gouv.vitam.common.mapping.dip.ManagementMapper;
import fr.gouv.vitam.common.mapping.dip.RuleMapper;
import fr.gouv.vitam.common.mapping.dip.TransformJsonTreeToListOfXmlElement;
import fr.gouv.vitam.common.model.unit.AdditionalProofType;
import fr.gouv.vitam.common.model.unit.ArchiveUnitHistoryModel;
import fr.gouv.vitam.common.model.unit.DescriptiveMetadataModel;
import fr.gouv.vitam.common.model.unit.EventTypeModel;
import fr.gouv.vitam.common.model.unit.GpsType;
import fr.gouv.vitam.common.model.unit.KeywordsType;
import fr.gouv.vitam.common.model.unit.LinkingAgentIdentifierTypeModel;
import fr.gouv.vitam.common.model.unit.OrganizationType;
import fr.gouv.vitam.common.model.unit.ReferencedObjectTypeModel;
import fr.gouv.vitam.common.model.unit.SignatureDescriptionTypeModel;
import fr.gouv.vitam.common.model.unit.SignatureInformationExtendedModel;
import fr.gouv.vitam.common.model.unit.SignatureTypeModel;
import fr.gouv.vitam.common.model.unit.SignedObjectDigestModel;
import fr.gouv.vitam.common.model.unit.SigningInformationTypeModel;
import fr.gouv.vitam.common.model.unit.SigningRoleType;
import fr.gouv.vitam.common.model.unit.TextByLang;
import fr.gouv.vitam.common.model.unit.TimestampingInformationTypeModel;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.collections4.CollectionUtils;
import org.w3c.dom.Element;

public class DescriptiveMetadataMapper {
    private final CustodialHistoryMapper custodialHistoryMapper = new CustodialHistoryMapper();
    private final ManagementMapper managementMapper = new ManagementMapper(new RuleMapper());

    public DescriptiveMetadataContentType map(DescriptiveMetadataModel metadataModel, List<ArchiveUnitHistoryModel> historyListModel, SupportedSedaVersions supportedSedaVersion) throws DatatypeConfigurationException, ExportException {
        DescriptiveMetadataMapper.checkSedaCompatibility(metadataModel, supportedSedaVersion);
        DescriptiveMetadataContentType dmc = new DescriptiveMetadataContentType();
        dmc.setAcquiredDate(metadataModel.getAcquiredDate());
        if (metadataModel.getAddressee() != null) {
            dmc.getAddressee().addAll(metadataModel.getAddressee());
        }
        dmc.getAny().addAll(TransformJsonTreeToListOfXmlElement.mapJsonToElement(metadataModel.getAny()));
        dmc.setCoverage(DescriptiveMetadataMapper.mapCoverage(metadataModel.getCoverage()));
        dmc.setCreatedDate(metadataModel.getCreatedDate());
        CustodialHistoryType custodialHistory = this.custodialHistoryMapper.map(metadataModel.getCustodialHistory());
        dmc.setCustodialHistory(custodialHistory);
        if (metadataModel.getDescription_() != null) {
            dmc.getDescription().addAll(this.mapTextByLang(metadataModel.getDescription_()));
        }
        if (metadataModel.getDescription() != null) {
            TextType description = new TextType();
            description.setValue(metadataModel.getDescription());
            dmc.getDescription().add(description);
        }
        dmc.setDescriptionLanguage(metadataModel.getDescriptionLanguage());
        dmc.setDescriptionLevel(this.mapLevelType(metadataModel.getDescriptionLevel()));
        dmc.setDocumentType(DescriptiveMetadataMapper.mapTextType(metadataModel.getDocumentType()));
        dmc.setEndDate(metadataModel.getEndDate());
        if (metadataModel.getEvent() != null) {
            dmc.getEvent().addAll(this.mapEvents(metadataModel.getEvent()));
        }
        dmc.setGps(this.mapGps(metadataModel.getGps()));
        dmc.setOriginatingAgency(this.mapOrganizationType(metadataModel.getOriginatingAgency()));
        if (metadataModel.getPersistentIdentifier() != null) {
            dmc.getPersistentIdentifier().addAll(metadataModel.getPersistentIdentifier());
        }
        if (metadataModel.getFilePlanPosition() != null && !metadataModel.getFilePlanPosition().isEmpty()) {
            dmc.getFilePlanPosition().addAll(metadataModel.getFilePlanPosition());
        }
        if (metadataModel.getSystemId() != null && !metadataModel.getSystemId().isEmpty()) {
            dmc.getSystemId().addAll(metadataModel.getSystemId());
        }
        if (metadataModel.getOriginatingSystemId() != null && !metadataModel.getOriginatingSystemId().isEmpty()) {
            dmc.getOriginatingSystemId().addAll(metadataModel.getOriginatingSystemId());
        }
        if (metadataModel.getArchivalAgencyArchiveUnitIdentifier() != null && !metadataModel.getArchivalAgencyArchiveUnitIdentifier().isEmpty()) {
            dmc.getArchivalAgencyArchiveUnitIdentifier().addAll(metadataModel.getArchivalAgencyArchiveUnitIdentifier());
        }
        if (metadataModel.getOriginatingAgencyArchiveUnitIdentifier() != null && !metadataModel.getOriginatingAgencyArchiveUnitIdentifier().isEmpty()) {
            dmc.getOriginatingAgencyArchiveUnitIdentifier().addAll(metadataModel.getOriginatingAgencyArchiveUnitIdentifier());
        }
        if (metadataModel.getTransferringAgencyArchiveUnitIdentifier() != null && !metadataModel.getTransferringAgencyArchiveUnitIdentifier().isEmpty()) {
            dmc.getTransferringAgencyArchiveUnitIdentifier().addAll(metadataModel.getTransferringAgencyArchiveUnitIdentifier());
        }
        if (metadataModel.getLanguage() != null && !metadataModel.getLanguage().isEmpty()) {
            dmc.getLanguage().addAll(metadataModel.getLanguage());
        }
        if (metadataModel.getAuthorizedAgent() != null && !metadataModel.getAuthorizedAgent().isEmpty()) {
            dmc.getAuthorizedAgent().addAll(metadataModel.getAuthorizedAgent());
        }
        if (CollectionUtils.isNotEmpty(metadataModel.getAgent())) {
            dmc.getAgent().addAll(metadataModel.getAgent());
        }
        if (CollectionUtils.isNotEmpty(metadataModel.getTextContent())) {
            dmc.getTextContent().addAll(metadataModel.getTextContent());
        }
        dmc.setOriginatingSystemIdReplyTo(metadataModel.getOriginatingSystemIdReplyTo());
        dmc.setDateLitteral(metadataModel.getDateLitteral());
        if (CollectionUtils.isNotEmpty(metadataModel.getSignature())) {
            dmc.getSignature().addAll(this.mapSignatures(metadataModel.getSignature()));
        }
        dmc.setSigningInformation(this.mapSigningInformation(metadataModel.getSigningInformation()));
        if (metadataModel.getRecipient() != null && !metadataModel.getRecipient().isEmpty()) {
            dmc.getRecipient().addAll(metadataModel.getRecipient());
        }
        if (metadataModel.getKeyword() != null && !metadataModel.getKeyword().isEmpty()) {
            dmc.getKeyword().addAll(DescriptiveMetadataMapper.mapKeywords(metadataModel.getKeyword()));
        }
        dmc.setReceivedDate(metadataModel.getReceivedDate());
        dmc.setRegisteredDate(metadataModel.getRegisteredDate());
        dmc.setRelatedObjectReference(metadataModel.getRelatedObjectReference());
        dmc.setRegisteredDate(metadataModel.getRegisteredDate());
        dmc.setSentDate(metadataModel.getSentDate());
        dmc.setSource(metadataModel.getSource());
        dmc.setStartDate(metadataModel.getStartDate());
        dmc.setStatus(metadataModel.getStatus());
        dmc.setSubmissionAgency(this.mapOrganizationType(metadataModel.getSubmissionAgency()));
        if (metadataModel.getTag() != null) {
            dmc.getTag().addAll(metadataModel.getTag());
        }
        if (metadataModel.getTitle_() != null) {
            dmc.getTitle().addAll(this.mapTextByLang(metadataModel.getTitle_()));
        }
        TextType title = new TextType();
        title.setValue(metadataModel.getTitle());
        dmc.getTitle().add(title);
        dmc.setTransactedDate(metadataModel.getTransactedDate());
        dmc.setType(DescriptiveMetadataMapper.mapTextType(metadataModel.getType()));
        dmc.setVersion(metadataModel.getVersion());
        if (metadataModel.getWriter() != null) {
            dmc.getWriter().addAll(metadataModel.getWriter());
        }
        if (metadataModel.getTransmitter() != null) {
            dmc.getTransmitter().addAll(metadataModel.getTransmitter());
        }
        if (metadataModel.getSender() != null) {
            dmc.getSender().addAll(metadataModel.getSender());
        }
        this.fillHistory(historyListModel, dmc.getHistory());
        return dmc;
    }

    private Collection<? extends TextType> mapTextByLang(TextByLang textByLang) {
        if (textByLang == null || textByLang.isEmpty()) {
            return Collections.emptyList();
        }
        return textByLang.getTextByLang().entrySet().stream().map(entry -> {
            TextType textType = new TextType();
            textType.setLang((String)entry.getKey());
            textType.setValue((String)entry.getValue());
            return textType;
        }).collect(Collectors.toList());
    }

    private fr.gouv.culture.archivesdefrance.seda.v2.OrganizationType mapOrganizationType(OrganizationType organization) {
        if (organization == null) {
            return null;
        }
        fr.gouv.culture.archivesdefrance.seda.v2.OrganizationType organizationType = new fr.gouv.culture.archivesdefrance.seda.v2.OrganizationType();
        organizationType.setIdentifier(DescriptiveMetadataMapper.mapIdentifier(organization.getIdentifier()));
        if (organization.getOrganizationDescriptiveMetadata() != null) {
            List<Element> elements = TransformJsonTreeToListOfXmlElement.mapJsonToElement(organization.getOrganizationDescriptiveMetadata());
            OrganizationDescriptiveMetadataType organizationDescriptiveMetadataType = new OrganizationDescriptiveMetadataType();
            organizationDescriptiveMetadataType.getAny().addAll(elements);
            organizationType.setOrganizationDescriptiveMetadata(organizationDescriptiveMetadataType);
        }
        return organizationType;
    }

    private static CoverageType mapCoverage(fr.gouv.vitam.common.model.unit.CoverageType coverage) {
        if (coverage == null) {
            return null;
        }
        CoverageType coverageType = new CoverageType();
        if (CollectionUtils.isNotEmpty(coverage.getSpatial())) {
            coverageType.getSpatial().addAll(coverage.getSpatial().stream().map(DescriptiveMetadataMapper::mapTextType).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(coverage.getTemporal())) {
            coverageType.getTemporal().addAll(coverage.getTemporal().stream().map(DescriptiveMetadataMapper::mapTextType).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(coverage.getJuridictional())) {
            coverageType.getJuridictional().addAll(coverage.getJuridictional().stream().map(DescriptiveMetadataMapper::mapTextType).collect(Collectors.toList()));
        }
        return coverageType;
    }

    private static TextType mapTextType(String value) {
        if (value == null) {
            return null;
        }
        TextType textType = new TextType();
        textType.setValue(value);
        return textType;
    }

    private static List<fr.gouv.culture.archivesdefrance.seda.v2.KeywordsType> mapKeywords(List<KeywordsType> keywords) {
        ArrayList<fr.gouv.culture.archivesdefrance.seda.v2.KeywordsType> result = new ArrayList<fr.gouv.culture.archivesdefrance.seda.v2.KeywordsType>();
        for (KeywordsType keyword : keywords) {
            fr.gouv.culture.archivesdefrance.seda.v2.KeywordsType sedaKeyword = new fr.gouv.culture.archivesdefrance.seda.v2.KeywordsType();
            if (keyword.getKeywordContent() != null) {
                TextType content = new TextType();
                content.setValue(keyword.getKeywordContent());
                sedaKeyword.setKeywordContent(content);
            }
            sedaKeyword.setKeywordReference(DescriptiveMetadataMapper.mapIdentifier(keyword.getKeywordReference()));
            if (keyword.getKeywordType() != null) {
                KeyType keyType = new KeyType();
                keyType.setValue(CodeKeywordType.fromValue(keyword.getKeywordType().value()));
                sedaKeyword.setKeywordType(keyType);
            }
            result.add(sedaKeyword);
        }
        return result;
    }

    private static IdentifierType mapIdentifier(String value) {
        if (value == null) {
            return null;
        }
        IdentifierType identifier = new IdentifierType();
        identifier.setValue(value);
        return identifier;
    }

    private fr.gouv.culture.archivesdefrance.seda.v2.GpsType mapGps(GpsType gps) {
        if (gps == null) {
            return null;
        }
        fr.gouv.culture.archivesdefrance.seda.v2.GpsType result = new fr.gouv.culture.archivesdefrance.seda.v2.GpsType();
        result.setGpsVersionID(gps.getGpsVersionID());
        result.setGpsAltitude(gps.getGpsAltitude());
        result.setGpsAltitudeRef(gps.getGpsAltitudeRef());
        result.setGpsLatitude(gps.getGpsLatitude());
        result.setGpsLatitudeRef(gps.getGpsLatitudeRef());
        result.setGpsLongitude(gps.getGpsLongitude());
        result.setGpsLongitudeRef(gps.getGpsLongitudeRef());
        result.setGpsDateStamp(gps.getGpsDateStamp());
        return result;
    }

    private LevelType mapLevelType(fr.gouv.vitam.common.model.unit.LevelType descriptionLevel) {
        if (descriptionLevel == null) {
            return null;
        }
        return LevelType.fromValue(descriptionLevel.value());
    }

    private static void checkSedaCompatibility(DescriptiveMetadataModel metadataModel, SupportedSedaVersions supportedSedaVersion) throws ExportException {
        if (supportedSedaVersion.equals((Object)SupportedSedaVersions.SEDA_2_3) && CollectionUtils.isNotEmpty(metadataModel.getSignature())) {
            throw new ExportException("Cannot export obsolete Signature tag into SEDA 2.3+.");
        }
        if ((supportedSedaVersion.equals((Object)SupportedSedaVersions.SEDA_2_1) || supportedSedaVersion.equals((Object)SupportedSedaVersions.SEDA_2_2)) && metadataModel.getSigningInformation() != null && (metadataModel.getGps() != null || CollectionUtils.isNotEmpty(metadataModel.getTextContent()) || CollectionUtils.isNotEmpty(metadataModel.getSignature()) || metadataModel.getOriginatingSystemIdReplyTo() != null)) {
            throw new ExportException("Cannot export SigningInformation tag in SEDA " + supportedSedaVersion.getVersion() + " with Signature, Gps, OriginatingSystemIdReplyTo or OriginatingSystemIdReplyTo fields");
        }
    }

    private List<SignatureType> mapSignatures(List<SignatureTypeModel> signatures) {
        if (signatures == null) {
            return null;
        }
        return signatures.stream().map(this::mapSignature).collect(Collectors.toList());
    }

    private SignatureType mapSignature(SignatureTypeModel signatureType) {
        SignatureType result = new SignatureType();
        if (signatureType.getSigner() != null) {
            result.getSigner().addAll(signatureType.getSigner());
        }
        result.setValidator(signatureType.getValidator());
        result.setReferencedObject(this.mapReferencedObject(signatureType.getReferencedObject()));
        result.setMasterdata(DescriptiveMetadataMapper.mapCodeType(signatureType.getMasterdata()));
        return result;
    }

    private static CodeType mapCodeType(String value) {
        if (value == null) {
            return null;
        }
        CodeType codeType = new CodeType();
        codeType.setValue(value);
        return codeType;
    }

    private ReferencedObjectType mapReferencedObject(ReferencedObjectTypeModel referencedObject) {
        if (referencedObject == null) {
            return null;
        }
        ReferencedObjectType result = new ReferencedObjectType();
        result.setSignedObjectId(referencedObject.getSignedObjectId());
        result.setSignedObjectDigest(this.mapSignedObjectDigest(referencedObject.getSignedObjectDigest()));
        return result;
    }

    private MessageDigestBinaryObjectType mapSignedObjectDigest(SignedObjectDigestModel signedMessageDigest) {
        if (signedMessageDigest == null) {
            return null;
        }
        MessageDigestBinaryObjectType result = new MessageDigestBinaryObjectType();
        result.setAlgorithm(signedMessageDigest.getAlgorithm());
        result.setValue(signedMessageDigest.getValue());
        return result;
    }

    private SigningInformationType mapSigningInformation(SigningInformationTypeModel signingInformation) throws DatatypeConfigurationException {
        if (signingInformation == null) {
            return null;
        }
        SigningInformationType signingInformationType = new SigningInformationType();
        if (signingInformation.getSigningRole() != null) {
            signingInformationType.getSigningRole().addAll(this.mapSigningRole(signingInformation.getSigningRole()));
        }
        if (signingInformation.getDetachedSigningRole() != null) {
            signingInformationType.getDetachedSigningRole().addAll(this.mapDetachedSigningRole(signingInformation.getDetachedSigningRole()));
        }
        if (signingInformation.getSignatureDescription() != null) {
            signingInformationType.getSignatureDescription().addAll(this.mapSignaturesDescription(signingInformation.getSignatureDescription()));
        }
        if (signingInformation.getTimestampingInformation() != null) {
            signingInformationType.getTimestampingInformation().addAll(this.mapTimestampingInformation(signingInformation.getTimestampingInformation()));
        }
        if (signingInformation.getAdditionalProof() != null) {
            signingInformationType.getAdditionalProof().addAll(this.mapAdditionalProofs(signingInformation.getAdditionalProof()));
        }
        signingInformationType.setExtended(this.mapExtendedParams(signingInformation.getExtended()));
        return signingInformationType;
    }

    private List<fr.gouv.culture.archivesdefrance.seda.v2.SigningRoleType> mapSigningRole(List<SigningRoleType> signingRole) {
        return signingRole.stream().map(role -> {
            switch (role) {
                case SIGNED_DOCUMENT: {
                    return fr.gouv.culture.archivesdefrance.seda.v2.SigningRoleType.SIGNED_DOCUMENT;
                }
                case TIMESTAMP: {
                    return fr.gouv.culture.archivesdefrance.seda.v2.SigningRoleType.TIMESTAMP;
                }
                case SIGNATURE: {
                    return fr.gouv.culture.archivesdefrance.seda.v2.SigningRoleType.SIGNATURE;
                }
                case ADDITIONAL_PROOF: {
                    return fr.gouv.culture.archivesdefrance.seda.v2.SigningRoleType.ADDITIONAL_PROOF;
                }
            }
            throw new IllegalStateException("Unexpected value: " + role);
        }).collect(Collectors.toList());
    }

    private List<DetachedSigningRoleType> mapDetachedSigningRole(List<fr.gouv.vitam.common.model.unit.DetachedSigningRoleType> detachedSigningRole) {
        return detachedSigningRole.stream().map(role -> {
            switch (role) {
                case TIMESTAMP: {
                    return DetachedSigningRoleType.TIMESTAMP;
                }
                case SIGNATURE: {
                    return DetachedSigningRoleType.SIGNATURE;
                }
                case ADDITIONAL_PROOF: {
                    return DetachedSigningRoleType.ADDITIONAL_PROOF;
                }
            }
            throw new IllegalStateException("Unexpected value: " + role);
        }).collect(Collectors.toList());
    }

    private List<SignatureDescriptionType> mapSignaturesDescription(List<SignatureDescriptionTypeModel> signature) {
        return signature.stream().map(this::mapSignature).collect(Collectors.toList());
    }

    private SignatureDescriptionType mapSignature(SignatureDescriptionTypeModel signatureTypeModel) {
        SignatureDescriptionType signatureDescriptionType = new SignatureDescriptionType();
        signatureDescriptionType.setSigner(signatureTypeModel.getSigner());
        signatureDescriptionType.setValidator(signatureTypeModel.getValidator());
        signatureDescriptionType.setSigningType(signatureTypeModel.getSigningType());
        return signatureDescriptionType;
    }

    private List<TimestampingInformationType> mapTimestampingInformation(List<TimestampingInformationTypeModel> timestampingInformation) throws DatatypeConfigurationException {
        ArrayList<TimestampingInformationType> timestampingInformationTypes = new ArrayList<TimestampingInformationType>();
        for (TimestampingInformationTypeModel timestampingInfo : timestampingInformation) {
            timestampingInformationTypes.add(this.mapTimestampingInformation(timestampingInfo));
        }
        return timestampingInformationTypes;
    }

    private TimestampingInformationType mapTimestampingInformation(TimestampingInformationTypeModel timestampingInfo) throws DatatypeConfigurationException {
        TimestampingInformationType timestampingInformationType = new TimestampingInformationType();
        Optional<XMLGregorianCalendar> timeStamp = this.stringToXMLGregorianCalendar(timestampingInfo.getTimeStamp());
        timeStamp.ifPresent(timestampingInformationType::setTimeStamp);
        timestampingInformationType.setAdditionalTimestampingInformation(timestampingInfo.getAdditionalTimestampingInformation());
        return timestampingInformationType;
    }

    private List<fr.gouv.culture.archivesdefrance.seda.v2.AdditionalProofType> mapAdditionalProofs(List<AdditionalProofType> additionalProofs) {
        return additionalProofs.stream().map(additionalProof -> {
            fr.gouv.culture.archivesdefrance.seda.v2.AdditionalProofType additionalProofType = new fr.gouv.culture.archivesdefrance.seda.v2.AdditionalProofType();
            additionalProofType.getAdditionalProofInformation().addAll(additionalProof.getAdditionalProofInformation());
            return additionalProofType;
        }).collect(Collectors.toList());
    }

    private ExtendedType mapExtendedParams(SignatureInformationExtendedModel extended) {
        if (extended == null || extended.getAny() == null || extended.getAny().isEmpty()) {
            return null;
        }
        ExtendedType extendedType = new ExtendedType();
        extendedType.getAny().addAll(TransformJsonTreeToListOfXmlElement.mapJsonToElement(extended.getAny()));
        return extendedType;
    }

    private List<EventType> mapEvents(List<EventTypeModel> eventTypes) {
        return eventTypes.stream().map(this::mapEvent).collect(Collectors.toList());
    }

    private EventType mapEvent(EventTypeModel event) {
        EventType eventType = new EventType();
        eventType.setEventDateTime(event.getEventDateTime());
        eventType.setEventDetail(DescriptiveMetadataMapper.mapTextType(event.getEventDetail()));
        eventType.setEventDetailData(event.getEventDetailData());
        eventType.setEventIdentifier(event.getEventIdentifier());
        eventType.setEventType(event.getEventType());
        eventType.setEventTypeCode(event.getEventTypeCode());
        eventType.setOutcome(event.getOutcome());
        eventType.setOutcomeDetail(event.getOutcomeDetail());
        eventType.setOutcomeDetailMessage(event.getOutcomeDetailMessage());
        if (Objects.nonNull(event.getLinkingAgentIdentifier())) {
            eventType.getLinkingAgentIdentifier().addAll(event.getLinkingAgentIdentifier().stream().map(this::mapLinkingAgentIdentifier).collect(Collectors.toList()));
        }
        return eventType;
    }

    private LinkingAgentIdentifierType mapLinkingAgentIdentifier(LinkingAgentIdentifierTypeModel linkingAgentIdentifierTypeModel) {
        if (linkingAgentIdentifierTypeModel == null) {
            return null;
        }
        LinkingAgentIdentifierType linkingAgentIdentifierType = new LinkingAgentIdentifierType();
        linkingAgentIdentifierType.setLinkingAgentIdentifierType(linkingAgentIdentifierTypeModel.getLinkingAgentIdentifierType());
        linkingAgentIdentifierType.setLinkingAgentIdentifierValue(linkingAgentIdentifierTypeModel.getLinkingAgentIdentifierValue());
        linkingAgentIdentifierType.setLinkingAgentRole(linkingAgentIdentifierTypeModel.getLinkingAgentRole());
        return linkingAgentIdentifierType;
    }

    private void fillHistory(List<ArchiveUnitHistoryModel> archiveUnitHistoryModel, List<ManagementHistoryType> managementHistoryType) throws DatatypeConfigurationException {
        for (ArchiveUnitHistoryModel historyModel : archiveUnitHistoryModel) {
            ManagementHistoryType historyType = new ManagementHistoryType();
            historyType.setData(new ManagementHistoryDataType());
            historyType.getData().setVersion(historyModel.getData().getVersion());
            historyType.getData().setManagement(this.managementMapper.map(historyModel.getData().getManagement()));
            Optional<XMLGregorianCalendar> updateDate = this.stringToXMLGregorianCalendar(historyModel.getUpdateDate());
            if (updateDate.isPresent()) {
                historyType.setUpdateDate(updateDate.get());
            }
            managementHistoryType.add(historyType);
        }
    }

    private Optional<XMLGregorianCalendar> stringToXMLGregorianCalendar(String date) throws DatatypeConfigurationException {
        if (ParametersChecker.isNotEmpty((String[])new String[]{date})) {
            return Optional.of(DatatypeFactory.newInstance().newXMLGregorianCalendar(date));
        }
        return Optional.empty();
    }
}

