/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mapping.dip;

import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveUnitType;
import fr.gouv.culture.archivesdefrance.seda.v2.IdentifierType;
import fr.gouv.vitam.common.exception.ExportException;
import fr.gouv.vitam.common.mapping.dip.DescriptiveMetadataMapper;
import fr.gouv.vitam.common.mapping.dip.ManagementMapper;
import fr.gouv.vitam.common.mapping.dip.RuleMapper;
import fr.gouv.vitam.common.model.unit.ArchiveUnitModel;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import javax.xml.datatype.DatatypeConfigurationException;

public class ArchiveUnitMapper {
    private DescriptiveMetadataMapper descriptiveMetadataMapper = new DescriptiveMetadataMapper();
    private RuleMapper ruleMapper = new RuleMapper();
    private ManagementMapper managementMapper = new ManagementMapper(this.ruleMapper);

    public ArchiveUnitType map(ArchiveUnitModel model, SupportedSedaVersions supportedSedaVersion) throws DatatypeConfigurationException, ExportException {
        ArchiveUnitType archiveUnitType = new ArchiveUnitType();
        archiveUnitType.setId(model.getId());
        if (model.getArchiveUnitProfile() != null) {
            IdentifierType identifierType = new IdentifierType();
            identifierType.setValue(model.getArchiveUnitProfile());
            archiveUnitType.setArchiveUnitProfile(identifierType);
        }
        archiveUnitType.setContent(this.descriptiveMetadataMapper.map(model.getDescriptiveMetadataModel(), model.getHistory(), supportedSedaVersion));
        if (!model.getManagement().isEmpty()) {
            archiveUnitType.setManagement(this.managementMapper.map(model.getManagement()));
        }
        return archiveUnitType;
    }
}

