/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.json;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public final class VitamDateTimeAttribute
extends AbstractFormatAttribute {
    private static final List<String> FORMATS = ImmutableList.of((Object)"yyyy-MM-dd'T'HH:mm:ss", (Object)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final DateTimeFormatter FORMATTER;
    private static final FormatAttribute INSTANCE;

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private VitamDateTimeAttribute() {
        super("date-time-vitam", NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String value = data.getInstance().getNode().textValue();
        try {
            FORMATTER.parseDateTime(value);
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(data, bundle, "err.format.invalidDate").putArgument("value", (Object)value).putArgument("expected", FORMATS));
        }
    }

    static {
        DateTimeParser msParser = new DateTimeFormatterBuilder().appendLiteral('.').appendDecimal(DateTimeFieldType.millisOfSecond(), 1, 3).toParser();
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder = builder.appendFixedDecimal(DateTimeFieldType.year(), 4).appendLiteral('-').appendFixedDecimal(DateTimeFieldType.monthOfYear(), 2).appendLiteral('-').appendFixedDecimal(DateTimeFieldType.dayOfMonth(), 2).appendLiteral('T').appendFixedDecimal(DateTimeFieldType.hourOfDay(), 2).appendLiteral(':').appendFixedDecimal(DateTimeFieldType.minuteOfHour(), 2).appendLiteral(':').appendFixedDecimal(DateTimeFieldType.secondOfMinute(), 2).appendOptional(msParser);
        FORMATTER = builder.toFormatter();
        INSTANCE = new VitamDateTimeAttribute();
    }
}

