/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.date.converter.resolver;

import fr.gouv.vitam.common.date.converter.resolver.DateResolver;
import fr.gouv.vitam.common.date.converter.resolver.OffsetOnlyResolver;
import fr.gouv.vitam.common.date.converter.resolver.TimeZoneAbbreviationResolver;
import fr.gouv.vitam.common.date.converter.resolver.XsdStandardDateResolver;
import fr.gouv.vitam.common.date.converter.resolver.ZuluMidnightResolver;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;

public class ResolverPipeline {
    private final List<DateResolver> resolvers;

    private ResolverPipeline(List<DateResolver> resolvers) {
        this.resolvers = List.copyOf(resolvers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public TemporalAccessor resolve(String input) {
        for (DateResolver resolver : this.resolvers) {
            if (!resolver.supports(input)) continue;
            return resolver.resolve(input);
        }
        throw new IllegalArgumentException("Unsupported date format: " + input);
    }

    public static class Builder {
        private final List<DateResolver> resolvers = new ArrayList<DateResolver>();

        public Builder addTimeZoneAbbreviationResolver() {
            this.resolvers.add(new TimeZoneAbbreviationResolver());
            return this;
        }

        public Builder addZuluMidnightResolver() {
            this.resolvers.add(new ZuluMidnightResolver());
            return this;
        }

        public Builder addOffsetOnlyResolver() {
            this.resolvers.add(new OffsetOnlyResolver());
            return this;
        }

        public Builder addXsdStandardResolver() {
            this.resolvers.add(new XsdStandardDateResolver());
            return this;
        }

        public ResolverPipeline build() {
            if (!(this.resolvers.size() == 4 && this.resolvers.get(0) instanceof TimeZoneAbbreviationResolver && this.resolvers.get(1) instanceof ZuluMidnightResolver && this.resolvers.get(2) instanceof OffsetOnlyResolver && this.resolvers.get(3) instanceof XsdStandardDateResolver)) {
                throw new IllegalStateException("Resolvers must be added in strict order.");
            }
            return new ResolverPipeline(this.resolvers);
        }
    }
}

