/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client.configuration;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.client.configuration.SSLConfiguration;
import fr.gouv.vitam.common.client.configuration.SecureClientConfiguration;

public class SecureClientConfigurationImpl
extends ClientConfigurationImpl
implements SecureClientConfiguration {
    private static final String CONFIGURATION_PARAMETERS = "SecureClientConfiguration parameters";
    private boolean secure = true;
    private SSLConfiguration sslConfiguration = new SSLConfiguration();
    private boolean hostnameVerification = true;

    public SecureClientConfigurationImpl() {
    }

    public SecureClientConfigurationImpl(String serverHost, int serverPort) {
        this(serverHost, serverPort, true, new SSLConfiguration(), true);
    }

    public SecureClientConfigurationImpl(String serverHost, int serverPort, boolean secure) {
        this(serverHost, serverPort, secure, new SSLConfiguration(), true);
    }

    public SecureClientConfigurationImpl(String serverHost, int serverPort, boolean secure, SSLConfiguration sslConfiguration) {
        this(serverHost, serverPort, secure, sslConfiguration, true);
    }

    public SecureClientConfigurationImpl(String serverHost, int serverPort, boolean secure, SSLConfiguration sslConfiguration, boolean hostnameVerification) {
        super(serverHost, serverPort);
        this.secure = secure;
        this.hostnameVerification = hostnameVerification;
        this.sslConfiguration = sslConfiguration;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public boolean isHostnameVerification() {
        return this.hostnameVerification;
    }

    @Override
    public SSLConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public SecureClientConfigurationImpl setHostnameVerification(boolean hostnameVerification) {
        this.hostnameVerification = hostnameVerification;
        return this;
    }

    public SecureClientConfigurationImpl setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public SecureClientConfigurationImpl setSslConfiguration(SSLConfiguration sslConfiguration) {
        ParametersChecker.checkParameter((String)CONFIGURATION_PARAMETERS, (Object[])new Object[]{sslConfiguration});
        this.sslConfiguration = sslConfiguration;
        return this;
    }
}

