/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client.configuration;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.configuration.SSLKey;
import fr.gouv.vitam.common.exception.VitamException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class SSLConfiguration {
    private static final String PARAMETERS = "SSLConfiguration parameters";
    private List<SSLKey> truststore;
    private List<SSLKey> keystore;
    private String protocol;

    public SSLConfiguration() {
    }

    public SSLConfiguration(List<SSLKey> keystore, List<SSLKey> truststore) {
        ParametersChecker.checkParameter((String)PARAMETERS, (Object[])new Object[]{truststore, keystore});
        this.truststore = truststore;
        this.keystore = keystore;
    }

    public Registry<ConnectionSocketFactory> getRegistry(SSLContext sslContext) throws FileNotFoundException {
        return RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
    }

    public SSLContext createSSLContext() throws VitamException {
        KeyManager[] keyManagers = null;
        if (this.keystore != null) {
            keyManagers = this.readKeyManagers();
        }
        TrustManager[] trustManagers = null;
        if (this.truststore == null || this.truststore.isEmpty()) {
            throw new VitamException("NO TrustStore specified: any remote certifcates would have been allowed, which is not acceptable!");
        }
        trustManagers = this.readTrustManagers();
        try {
            if (this.protocol == null || this.protocol.isEmpty()) {
                this.protocol = "TLSv1.2";
            }
            SSLContext sslContext = SSLContext.getInstance(this.protocol);
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new VitamException((Throwable)e);
        }
    }

    private KeyManager[] readKeyManagers() throws VitamException {
        KeyManager[] result = new KeyManager[]{};
        for (SSLKey key : this.keystore) {
            result = SSLConfiguration.concat(result, this.loadKeyManagers(key.getKeyPath(), key.getKeyPassword()), KeyManager.class);
        }
        return result;
    }

    private TrustManager[] readTrustManagers() throws VitamException {
        TrustManager[] result = new TrustManager[]{};
        for (SSLKey key : this.truststore) {
            result = SSLConfiguration.concat(result, this.loadTrustManagers(key.getKeyPath(), key.getKeyPassword()), TrustManager.class);
        }
        return result;
    }

    private TrustManager[] loadTrustManagers(String filePath, String pwd) throws VitamException {
        TrustManager[] trustManagerArray;
        block8: {
            ParametersChecker.checkParameter((String)PARAMETERS, (String[])new String[]{filePath, pwd});
            char[] password = this.readPassword(pwd);
            InputStream trustInputStream = this.readInputStream(filePath);
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(trustInputStream, password);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keyStore);
                trustManagerArray = tmf.getTrustManagers();
                if (trustInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (trustInputStream != null) {
                        try {
                            trustInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new VitamException((Throwable)e);
                }
            }
            trustInputStream.close();
        }
        return trustManagerArray;
    }

    private KeyManager[] loadKeyManagers(String filePath, String pwd) throws VitamException {
        KeyManager[] keyManagerArray;
        block8: {
            ParametersChecker.checkParameter((String)PARAMETERS, (String[])new String[]{filePath, pwd});
            char[] password = this.readPassword(pwd);
            InputStream keyInputStream = this.readInputStream(filePath);
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(keyInputStream, password);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, password);
                keyManagerArray = kmf.getKeyManagers();
                if (keyInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (keyInputStream != null) {
                        try {
                            keyInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    throw new VitamException((Throwable)e);
                }
            }
            keyInputStream.close();
        }
        return keyManagerArray;
    }

    private char[] readPassword(String pwd) throws VitamException {
        ParametersChecker.checkParameter((String)PARAMETERS, (String[])new String[]{pwd});
        return pwd.toCharArray();
    }

    private InputStream readInputStream(String filePath) throws VitamException {
        ParametersChecker.checkParameter((String)PARAMETERS, (String[])new String[]{filePath});
        try {
            return new FileInputStream(PropertiesUtils.findFile((String)filePath));
        }
        catch (FileNotFoundException e) {
            throw new VitamException((Throwable)e);
        }
    }

    public List<SSLKey> getTruststore() {
        return this.truststore;
    }

    public List<SSLKey> getKeystore() {
        return this.keystore;
    }

    public SSLConfiguration setTruststore(List<SSLKey> truststore) {
        this.truststore = truststore;
        return this;
    }

    public SSLConfiguration setKeystore(List<SSLKey> keystore) {
        this.keystore = keystore;
        return this;
    }

    private static <T> T[] concat(T[] first, T[] second, Class<T> type) {
        Object[] result = (Object[])Array.newInstance(type, first.length + second.length);
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

