/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.HeaderIdClientFilter;
import fr.gouv.vitam.common.client.MockOrRestClient;
import fr.gouv.vitam.common.client.VitamApacheHttpClientEngine;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRestEasyConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.client.configuration.SSLConfiguration;
import fr.gouv.vitam.common.client.configuration.SecureClientConfiguration;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.plugins.interceptors.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;

public abstract class VitamClientFactory<T extends MockOrRestClient>
implements VitamClientFactoryInterface<T> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamClientFactory.class);
    static final AtomicBoolean INIT_STATIC_CONFIG = new AtomicBoolean(false);
    static final PoolingHttpClientConnectionManager POOLING_CONNECTION_MANAGER = new PoolingHttpClientConnectionManager((long)VitamConfiguration.getMaxDelayUnusedConnection().intValue(), TimeUnit.MILLISECONDS);
    static final PoolingHttpClientConnectionManager POOLING_CONNECTION_MANAGER_NOT_CHUNKED = new PoolingHttpClientConnectionManager((long)VitamConfiguration.getMaxDelayUnusedConnection().intValue(), TimeUnit.MILLISECONDS);
    static final Queue<PoolingHttpClientConnectionManager> allManagers = new ConcurrentLinkedQueue<PoolingHttpClientConnectionManager>();
    static final AtomicBoolean STATIC_IDLE_MONITOR = new AtomicBoolean(false);
    static final SocketConfig SOCKETCONFIG = SocketConfig.custom().setRcvBufSize(VitamConfiguration.getRecvBufferSize().intValue()).setSndBufSize(VitamConfiguration.getChunkSize().intValue()).setSoKeepAlive(true).setSoReuseAddress(true).setTcpNoDelay(true).setSoTimeout(VitamConfiguration.getReadTimeout().intValue()).build();
    static final SocketConfig SOCKETCONFIG_NONCHUNKED = SocketConfig.custom().setRcvBufSize(VitamConfiguration.getRecvBufferSize().intValue()).setSndBufSize(0).setSoKeepAlive(true).setSoReuseAddress(true).setTcpNoDelay(true).setSoTimeout(VitamConfiguration.getReadTimeout().intValue()).build();
    final ExpiredConnectionMonitorThread idleMonitor;
    private String serviceUrl;
    private String resourcePath;
    private boolean cacheable;
    protected ClientConfiguration clientConfiguration;
    private boolean chunkedMode;
    private Client givenClient;
    private Client givenClientNotChunked;
    private VitamClientFactoryInterface.VitamClientType vitamClientType = VitamClientFactoryInterface.VitamClientType.MOCK;
    private final RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(VitamConfiguration.getDelayGetClient().intValue()).build();
    PoolingHttpClientConnectionManager chunkedPoolingManager;
    PoolingHttpClientConnectionManager notChunkedPoolingManager;
    VitamThreadPoolExecutor vitamThreadPoolExecutor = VitamThreadPoolExecutor.getDefaultExecutor();
    SSLConfiguration sslConfiguration = null;
    private boolean useAuthorizationFilter = true;
    private boolean allowGzipEncoded = VitamConfiguration.isAllowGzipEncoding();
    private boolean allowGzipDecoded = VitamConfiguration.isAllowGzipDecoding();
    private final Map<VitamRestEasyConfiguration, Object> config = new EnumMap<VitamRestEasyConfiguration, Object>(VitamRestEasyConfiguration.class);
    private final Map<VitamRestEasyConfiguration, Object> configNotChunked = new EnumMap<VitamRestEasyConfiguration, Object>(VitamRestEasyConfiguration.class);

    protected VitamClientFactory(ClientConfiguration configuration, String resourcePath) {
        this(configuration, resourcePath, true, false);
    }

    protected VitamClientFactory(ClientConfiguration configuration, String resourcePath, boolean cacheable) {
        this(configuration, resourcePath, true, cacheable);
    }

    protected VitamClientFactory(ClientConfiguration configuration, String resourcePath, boolean chunkedMode, boolean cacheable) {
        this.initialisation(configuration, resourcePath);
        this.chunkedMode = chunkedMode;
        this.cacheable = cacheable;
        this.givenClient = null;
        this.givenClientNotChunked = null;
        if (STATIC_IDLE_MONITOR.compareAndSet(false, true)) {
            this.idleMonitor = new ExpiredConnectionMonitorThread();
            this.startupMonitor();
        } else {
            this.idleMonitor = null;
        }
        if (configuration != null) {
            this.useAuthorizationFilter = !configuration.isSecure();
        }
    }

    protected VitamClientFactory(ClientConfiguration configuration, String resourcePath, Client client) {
        ParametersChecker.checkParameter((String)"Client cannot be null", (Object[])new Object[]{client});
        this.initialisation(configuration, resourcePath);
        this.givenClient = client;
        this.givenClientNotChunked = client;
        this.idleMonitor = new ExpiredConnectionMonitorThread();
    }

    protected void disableUseAuthorizationFilter() {
        this.useAuthorizationFilter = false;
    }

    protected void enableUseAuthorizationFilter() {
        this.useAuthorizationFilter = true;
    }

    boolean useAuthorizationFilter() {
        return this.useAuthorizationFilter;
    }

    boolean useAuthorizationFilterAndHaveSecret() {
        return this.useAuthorizationFilter && StringUtils.isNotBlank((CharSequence)VitamConfiguration.getSecret());
    }

    public void setGzipEncoded(boolean allowGzipEncoded) {
        this.allowGzipEncoded = allowGzipEncoded;
        this.config.put(VitamRestEasyConfiguration.CONTENTCOMPRESSIONENABLED, allowGzipEncoded);
        this.configNotChunked.put(VitamRestEasyConfiguration.CONTENTCOMPRESSIONENABLED, allowGzipEncoded);
    }

    protected boolean isAllowGzipEncoded() {
        return this.allowGzipEncoded;
    }

    public void setGzipdecoded(boolean allowGzipDecoded) {
        this.allowGzipDecoded = allowGzipDecoded;
    }

    protected boolean isAllowGzipDecoded() {
        return this.allowGzipDecoded;
    }

    protected final void initialisation(ClientConfiguration configuration, String resourcePath) {
        if (configuration == null) {
            this.setVitamClientType(VitamClientFactoryInterface.VitamClientType.MOCK);
            this.clientConfiguration = new ClientConfigurationImpl();
        } else {
            this.setVitamClientType(VitamClientFactoryInterface.VitamClientType.PRODUCTION);
            this.clientConfiguration = configuration;
            ParametersChecker.checkParameter((String)"Host cannot be null", (String[])new String[]{this.clientConfiguration.getServerHost()});
            ParametersChecker.checkValue((String)"Port has invalid value", (long)this.clientConfiguration.getServerPort(), (long)1L);
        }
        ParametersChecker.checkParameter((String)"resourcePath cannot be null", (String[])new String[]{resourcePath});
        this.resourcePath = Optional.ofNullable(resourcePath).orElse("/");
        if (this.resourcePath.codePointAt(0) != 47) {
            this.resourcePath = "/" + this.resourcePath;
        }
        this.serviceUrl = (this.clientConfiguration.isSecure() ? "https://" : "http://") + this.clientConfiguration.getServerHost() + ":" + this.clientConfiguration.getServerPort() + this.resourcePath;
        if (this.chunkedPoolingManager != null && this.chunkedPoolingManager != POOLING_CONNECTION_MANAGER) {
            allManagers.remove(this.chunkedPoolingManager);
            this.chunkedPoolingManager.close();
        }
        if (this.notChunkedPoolingManager != null && this.notChunkedPoolingManager != POOLING_CONNECTION_MANAGER_NOT_CHUNKED) {
            allManagers.remove(this.notChunkedPoolingManager);
            this.notChunkedPoolingManager.close();
        }
        this.configure(this.config, true);
        this.configure(this.configNotChunked, false);
        if (this.clientConfiguration.isSecure()) {
            Registry<ConnectionSocketFactory> registry;
            SecureClientConfiguration sclientConfiguration = (SecureClientConfiguration)this.clientConfiguration;
            this.sslConfiguration = sclientConfiguration.getSslConfiguration();
            ParametersChecker.checkParameter((String)"sslConfiguration is a mandatory parameter", (Object[])new Object[]{this.sslConfiguration});
            try {
                SSLContext context = this.sslConfiguration.createSSLContext();
                this.config.put(VitamRestEasyConfiguration.SSL_CONTEXT, context);
                this.configNotChunked.put(VitamRestEasyConfiguration.SSL_CONTEXT, context);
                registry = this.sslConfiguration.getRegistry(context);
            }
            catch (VitamException | FileNotFoundException e) {
                LOGGER.error(e);
                throw new IllegalArgumentException("SSLConfiguration issue while reading KeyStore or TrustStore", e);
            }
            PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager(registry, null, null, null, (long)VitamConfiguration.getMaxDelayUnusedConnection().intValue(), TimeUnit.MILLISECONDS);
            VitamClientFactory.setupApachePool(pool);
            pool.setDefaultSocketConfig(SOCKETCONFIG);
            this.chunkedPoolingManager = pool;
            allManagers.add(this.chunkedPoolingManager);
            pool = new PoolingHttpClientConnectionManager(registry, null, null, null, (long)VitamConfiguration.getMaxDelayUnusedConnection().intValue(), TimeUnit.MILLISECONDS);
            VitamClientFactory.setupApachePool(pool);
            pool.setDefaultSocketConfig(SOCKETCONFIG_NONCHUNKED);
            this.notChunkedPoolingManager = pool;
            allManagers.add(this.notChunkedPoolingManager);
        } else {
            this.chunkedPoolingManager = POOLING_CONNECTION_MANAGER;
            this.notChunkedPoolingManager = POOLING_CONNECTION_MANAGER_NOT_CHUNKED;
        }
        this.config.put(VitamRestEasyConfiguration.CONNECTION_MANAGER, this.chunkedPoolingManager);
        this.configNotChunked.put(VitamRestEasyConfiguration.CONNECTION_MANAGER, this.notChunkedPoolingManager);
    }

    public void changeResourcePath(String resourcePath) {
        this.initialisation(this.clientConfiguration, resourcePath);
    }

    public void changeServerPort(int port) {
        try {
            ParametersChecker.checkParameter((String)"Host cannot be null", (String[])new String[]{this.clientConfiguration.getServerHost()});
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug((Throwable)e);
            this.clientConfiguration.setServerHost("localhost");
        }
        this.initialisation(this.clientConfiguration.setServerPort(port), this.getResourcePath());
    }

    public VitamClientFactoryInterface.VitamClientType getVitamClientType() {
        return this.vitamClientType;
    }

    public VitamClientFactory<T> setVitamClientType(VitamClientFactoryInterface.VitamClientType vitamClientType) {
        this.vitamClientType = vitamClientType;
        return this;
    }

    private Client buildClient(Map<VitamRestEasyConfiguration, Object> config) {
        if (this.givenClient != null) {
            return this.givenClient;
        }
        VitamApacheHttpClientEngine engine = new VitamApacheHttpClientEngine(config);
        ResteasyClientBuilder builder = this.configureRestEasy(config, engine);
        return builder.build();
    }

    public void resume(Client client, boolean chunk) {
        if (!VitamConfiguration.isUseNewJaxrClient().booleanValue()) {
            return;
        }
        client.close();
    }

    boolean getChunkedMode() {
        return this.chunkedMode;
    }

    public Client getHttpClient() {
        return this.getHttpClient(this.chunkedMode);
    }

    public Client getHttpClient(boolean useChunkedMode) {
        if (useChunkedMode && this.givenClient != null) {
            return this.givenClient;
        }
        if (!useChunkedMode && this.givenClientNotChunked != null) {
            return this.givenClientNotChunked;
        }
        if (useChunkedMode) {
            Client client = this.buildClient(this.config);
            if (!VitamConfiguration.isUseNewJaxrClient().booleanValue()) {
                this.givenClient = client;
            }
            return client;
        }
        Client client = this.buildClient(this.configNotChunked);
        if (!VitamConfiguration.isUseNewJaxrClient().booleanValue()) {
            this.givenClientNotChunked = client;
        }
        return client;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String toString() {
        return "VitamFactory: { " + "ServiceUrl: " + this.serviceUrl + ", ResourcePath: " + this.resourcePath + ", ChunkedMode: " + this.chunkedMode + ", Configuration: { Properties: \"" + this.config + "\" }" + " }";
    }

    public final ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public final Map<VitamRestEasyConfiguration, Object> getDefaultConfigCient() {
        return Collections.unmodifiableMap(this.config);
    }

    public final Map<VitamRestEasyConfiguration, Object> getDefaultConfigCient(boolean chunkedMode) {
        if (chunkedMode) {
            return Collections.unmodifiableMap(this.config);
        }
        return Collections.unmodifiableMap(this.configNotChunked);
    }

    public synchronized void shutdown() {
        if (this.idleMonitor != null && !STATIC_IDLE_MONITOR.get()) {
            this.idleMonitor.shutdown();
            this.idleMonitor.interrupt();
        }
        if (this.chunkedPoolingManager != null && this.chunkedPoolingManager != POOLING_CONNECTION_MANAGER) {
            allManagers.remove(this.chunkedPoolingManager);
            this.chunkedPoolingManager.close();
            this.givenClient = null;
        }
        if (this.notChunkedPoolingManager != null && this.notChunkedPoolingManager != POOLING_CONNECTION_MANAGER_NOT_CHUNKED) {
            allManagers.remove(this.notChunkedPoolingManager);
            this.notChunkedPoolingManager.close();
            this.givenClientNotChunked = null;
        }
    }

    @VisibleForTesting
    public static void resetConnections() {
        for (PoolingHttpClientConnectionManager manager : allManagers) {
            manager.closeExpiredConnections();
            manager.closeIdleConnections(0L, TimeUnit.MICROSECONDS);
        }
    }

    private static void setupApachePool(PoolingHttpClientConnectionManager manager) {
        manager.setMaxTotal(VitamConfiguration.getMaxTotalClient().intValue());
        manager.setDefaultMaxPerRoute(VitamConfiguration.getMaxClientPerHost().intValue());
        manager.setValidateAfterInactivity(VitamConfiguration.getDelayValidationAfterInactivity().intValue());
    }

    private void startupMonitor() {
        if (this.idleMonitor != null) {
            this.idleMonitor.setDaemon(true);
            this.idleMonitor.start();
        }
    }

    private ResteasyClientBuilder configureRestEasy(Map<VitamRestEasyConfiguration, Object> config, ClientHttpEngine engine) {
        ResteasyClientBuilder clientBuilder = (ResteasyClientBuilder)ClientBuilder.newBuilder();
        clientBuilder.httpEngine(engine);
        clientBuilder.connectionCheckoutTimeout((long)VitamRestEasyConfiguration.CONNECTIONREQUESTTIMEOUT.getInt(config, 1000), TimeUnit.MILLISECONDS);
        clientBuilder.connectTimeout((long)VitamRestEasyConfiguration.CONNECT_TIMEOUT.getInt(config, 1000), TimeUnit.MILLISECONDS);
        clientBuilder.readTimeout((long)VitamRestEasyConfiguration.READ_TIMEOUT.getInt(config, 100000), TimeUnit.MILLISECONDS);
        clientBuilder.executorService((ExecutorService)this.vitamThreadPoolExecutor);
        if (this.isAllowGzipDecoded()) {
            clientBuilder.register(AcceptEncodingGZIPFilter.class);
            clientBuilder.register(GZIPDecodingInterceptor.class);
        }
        if (this.isAllowGzipEncoded()) {
            clientBuilder.register(GZIPEncodingInterceptor.class);
        }
        if (this.useAuthorizationFilter()) {
            clientBuilder.register(HeaderIdClientFilter.class);
        }
        return clientBuilder;
    }

    void configure(Map<VitamRestEasyConfiguration, Object> config, boolean chunkedMode) {
        config.put(VitamRestEasyConfiguration.CONNECT_TIMEOUT, VitamConfiguration.getConnectTimeout());
        config.put(VitamRestEasyConfiguration.CONNECTTIMEOUT, VitamConfiguration.getConnectTimeout());
        config.put(VitamRestEasyConfiguration.CONNECTIONREQUESTTIMEOUT, VitamConfiguration.getDelayGetClient());
        config.put(VitamRestEasyConfiguration.READ_TIMEOUT, VitamConfiguration.getReadTimeout());
        config.put(VitamRestEasyConfiguration.SOCKETTIMEOUT, VitamConfiguration.getReadTimeout());
        config.put(VitamRestEasyConfiguration.CONTENTCOMPRESSIONENABLED, this.allowGzipEncoded);
        if (chunkedMode) {
            config.put(VitamRestEasyConfiguration.CHUNKED_ENCODING_SIZE, VitamConfiguration.getChunkSize());
            config.put(VitamRestEasyConfiguration.REQUEST_ENTITY_PROCESSING, "CHUNKED");
        } else {
            config.put(VitamRestEasyConfiguration.CHUNKED_ENCODING_SIZE, 0);
            config.put(VitamRestEasyConfiguration.REQUEST_ENTITY_PROCESSING, "BUFFERED");
        }
        config.put(VitamRestEasyConfiguration.CACHE_ENABLED, this.cacheable);
        config.put(VitamRestEasyConfiguration.RECV_BUFFER_SIZE, VitamConfiguration.getRecvBufferSize());
        config.put(VitamRestEasyConfiguration.CONNECTION_MANAGER_SHARED, true);
        config.put(VitamRestEasyConfiguration.DISABLE_AUTOMATIC_RETRIES, true);
        config.put(VitamRestEasyConfiguration.REQUEST_CONFIG, this.requestConfig);
    }

    public VitamThreadPoolExecutor getVitamThreadPoolExecutor() {
        return this.vitamThreadPoolExecutor;
    }

    static {
        if (INIT_STATIC_CONFIG.compareAndSet(false, true)) {
            VitamClientFactory.setupApachePool(POOLING_CONNECTION_MANAGER);
            POOLING_CONNECTION_MANAGER.setDefaultSocketConfig(SOCKETCONFIG);
            VitamClientFactory.setupApachePool(POOLING_CONNECTION_MANAGER_NOT_CHUNKED);
            POOLING_CONNECTION_MANAGER_NOT_CHUNKED.setDefaultSocketConfig(SOCKETCONFIG_NONCHUNKED);
            allManagers.add(POOLING_CONNECTION_MANAGER);
            allManagers.add(POOLING_CONNECTION_MANAGER_NOT_CHUNKED);
        }
    }

    private static class ExpiredConnectionMonitorThread
    extends Thread {
        volatile boolean shutdown;

        ExpiredConnectionMonitorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    ExpiredConnectionMonitorThread expiredConnectionMonitorThread = this;
                    synchronized (expiredConnectionMonitorThread) {
                        this.wait(VitamConfiguration.getIntervalDelayCheckIdle().intValue());
                        for (PoolingHttpClientConnectionManager poolingHttpClientConnectionManager : allManagers) {
                            poolingHttpClientConnectionManager.closeExpiredConnections();
                        }
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            ExpiredConnectionMonitorThread expiredConnectionMonitorThread = this;
            synchronized (expiredConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

