/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

public enum CustomVitamHttpStatusCode {
    UNAVAILABLE_DATA_FROM_ASYNC_OFFER(460, "Access to data from async offer without active access request"),
    UNAVAILABLE_ASYNC_DATA_RETRY_LATER(461, "Required async data is currently unavailable, retry later");

    private final int statusCode;
    private final String message;

    private CustomVitamHttpStatusCode(int statusCode, String message) {
        this.statusCode = statusCode;
        this.message = message;
    }

    public static CustomVitamHttpStatusCode fromStatusCode(int statusCode) {
        CustomVitamHttpStatusCode[] values;
        for (CustomVitamHttpStatusCode value : values = CustomVitamHttpStatusCode.values()) {
            if (value.statusCode != statusCode) continue;
            return value;
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        return "Custom Vitam HTTP Status Code: " + this.statusCode + "-" + this.name();
    }

    public String getMessage() {
        return this.message;
    }
}

