/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

import fr.gouv.vitam.common.CommonMediaType;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.BasicClient;
import fr.gouv.vitam.common.client.VitamAutoClosableResponse;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.VitamApplicationServerDisconnectException;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.retryable.DelegateRetry;
import fr.gouv.vitam.common.retryable.RetryableOnException;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import fr.gouv.vitam.common.security.codec.URLCodec;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.InputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;

abstract class AbstractCommonClient
implements BasicClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AbstractCommonClient.class);
    private final RetryableParameters retryableParameters;
    private final VitamClientFactory<?> clientFactory;
    private final Client client;
    private final Client chunkedClient;
    private final Predicate<Exception> retryOnException = e -> {
        if (this.isNetworkException((Throwable)e)) {
            return true;
        }
        List throwableList = ExceptionUtils.getThrowableList((Throwable)e);
        for (Throwable th : throwableList) {
            if (!this.isNetworkException(th)) continue;
            return true;
        }
        return false;
    };

    private boolean isNetworkException(Throwable th) {
        return th instanceof ConnectTimeoutException || th instanceof UnknownHostException || th instanceof NoHttpResponseException || th instanceof SocketException;
    }

    AbstractCommonClient(VitamClientFactoryInterface<?> factory) {
        this.clientFactory = (VitamClientFactory)factory;
        this.chunkedClient = factory.getHttpClient(true);
        this.client = factory.getHttpClient(false);
        this.retryableParameters = new RetryableParameters(VitamConfiguration.getHttpClientRetry(), VitamConfiguration.getHttpClientFirstAttemptWaitingTime(), VitamConfiguration.getHttpClientWaitingTime(), VitamConfiguration.getHttpClientRandomWaitingSleep(), TimeUnit.SECONDS);
    }

    public static void staticConsumeAnyEntityAndClose(Response response) {
        try {
            Object object;
            if (response != null && response.hasEntity() && (object = response.getEntity()) instanceof InputStream) {
                StreamUtils.closeSilently((InputStream)((InputStream)object));
            }
        }
        catch (Exception e) {
            LOGGER.info((Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception e) {
                    LOGGER.debug((Throwable)e);
                }
            }
        }
    }

    public final void consumeAnyEntityAndClose(Response response) {
        AbstractCommonClient.staticConsumeAnyEntityAndClose(response);
    }

    public void checkStatus() throws VitamApplicationServerException {
        this.checkStatus(null);
    }

    public void checkStatus(MultivaluedHashMap<String, Object> headers) throws VitamApplicationServerException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/status").withJsonAccept();
        if (headers != null) {
            request.withHeaders(headers);
        }
        try (Response response = this.make(request);){
            Response.Status status = response.getStatusInfo().toEnum();
            if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
                return;
            }
            throw new VitamApplicationServerException(status.getReasonPhrase());
        }
        catch (VitamClientInternalException e) {
            throw new VitamApplicationServerDisconnectException((Throwable)e);
        }
    }

    public String getResourcePath() {
        return this.clientFactory.getResourcePath();
    }

    public String getServiceUrl() {
        return this.clientFactory.getServiceUrl();
    }

    public void close() {
        if (this.client != null) {
            this.clientFactory.resume(this.client, false);
        }
        if (this.chunkedClient != null) {
            this.clientFactory.resume(this.chunkedClient, true);
        }
    }

    public String toString() {
        return "VitamClient: { " + this.clientFactory.toString() + " }";
    }

    public Response makeSpecifyingUrl(VitamRequestBuilder request) throws VitamClientInternalException {
        if (StringUtils.isBlank((CharSequence)request.getBaseUrl())) {
            throw new VitamRuntimeException("Base URL must not be 'null nor empty' with method 'makeSpecifyingUrl'.");
        }
        return this.doRequest(request);
    }

    public Response make(VitamRequestBuilder request) throws VitamClientInternalException {
        if (StringUtils.isNotBlank((CharSequence)request.getBaseUrl())) {
            throw new VitamRuntimeException(String.format("Base URL must not be 'set' with method 'make' it will be override, here it equals '%s'.", request.getBaseUrl()));
        }
        request.withBaseUrl(this.getServiceUrl());
        return this.doRequest(request);
    }

    private Response doRequest(VitamRequestBuilder request) throws VitamClientInternalException {
        request.runBeforeExecRequest();
        if (this.clientFactory.isAllowGzipEncoded()) {
            request.withHeader("Content-Encoding", (Object)CommonMediaType.GZIP_TYPE.getSubtype());
        }
        if (this.clientFactory.isAllowGzipDecoded()) {
            request.withHeader("Accept-Encoding", (Object)CommonMediaType.GZIP_TYPE.getSubtype());
        }
        try {
            DelegateRetry invocation = () -> {
                Object body;
                if (this.clientFactory.useAuthorizationFilterAndHaveSecret()) {
                    String xTimestamp = this.getXTimestamp();
                    request.withHeaderReplaceExisting("X-Timestamp", (Object)xTimestamp);
                    request.withHeaderReplaceExisting("X-Platform-Id", (Object)this.getXPlatformId(request, xTimestamp));
                }
                if ((body = request.getBody()) == null) {
                    return this.builder(request).method(request.getHttpMethod());
                }
                return this.builder(request).method(request.getHttpMethod(), Entity.entity((Object)body, (MediaType)request.getContentType()));
            };
            if (AbstractCommonClient.isNonRetryable(request)) {
                return new VitamAutoClosableResponse((Response)invocation.call());
            }
            return new VitamAutoClosableResponse((Response)this.retryable().exec(invocation));
        }
        catch (ProcessingException e) {
            throw new VitamClientInternalException((Throwable)e);
        }
    }

    private static boolean isNonRetryable(VitamRequestBuilder request) {
        if (request.getBody() instanceof InputStream) {
            return true;
        }
        switch (request.getHttpMethod()) {
            case "GET": 
            case "HEAD": 
            case "DELETE": 
            case "OPTIONS": 
            case "PUT": {
                return false;
            }
            case "POST": {
                return true;
            }
        }
        throw new IllegalStateException("Unexpected value: " + request.getHttpMethod());
    }

    private RetryableOnException<Response, ProcessingException> retryable() {
        return new RetryableOnException(this.retryableParameters, this.retryOnException);
    }

    private Invocation.Builder builder(VitamRequestBuilder request) {
        Client client = request.isChunckedMode() ? this.chunkedClient : this.client;
        WebTarget webTarget = client.target(request.getBaseUrl()).path(request.getPath());
        for (Map.Entry entry : request.getQueryParams().entrySet()) {
            webTarget = webTarget.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
        }
        return webTarget.request().headers(request.getHeaders()).accept(new MediaType[]{request.getAccept()});
    }

    private String getXTimestamp() {
        return Long.toString(Instant.now().getEpochSecond());
    }

    private String getXPlatformId(VitamRequestBuilder request, String xTimestamp) {
        return URLCodec.encodeURL(request.getHttpMethod(), this.getAuthorizationUrl(request.getPath(), request.getBaseUrl()), xTimestamp, VitamConfiguration.getSecret(), VitamConfiguration.getSecurityDigestType());
    }

    private String getAuthorizationUrl(String originalPath, String baseUrl) {
        Object path;
        Object object = path = originalPath.startsWith("/") ? originalPath : "/" + originalPath;
        if (baseUrl.endsWith("/admin/v1")) {
            return "/admin/v1" + this.getResourcePath() + (String)path;
        }
        return this.getResourcePath() + (String)path;
    }

    public VitamClientFactory<?> getClientFactory() {
        return this.clientFactory;
    }

    public Client getClient() {
        return this.client;
    }

    public Client getChunkedClient() {
        return this.chunkedClient;
    }
}

