/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.auth.web.filter;

import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.auth.core.authc.X509AuthenticationToken;
import fr.gouv.vitam.common.auth.web.filter.CertUtils;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.ShiroException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;

public class X509AuthenticationFilter
extends AuthenticatingFilter {
    private boolean useHeader = false;

    public void setUseHeader(boolean useHeader) {
        this.useHeader = useHeader;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (!this.executeLogin(request, response)) {
            ((HttpServletResponse)response).sendError(403, "Access Denied . Need a valid TLS client certificate");
            return false;
        }
        return true;
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        X509AuthenticationToken x509Token = (X509AuthenticationToken)token;
        X509Certificate x509Certificate = x509Token.getX509Certificate();
        byte[] derEncodedCertificate = x509Certificate.getEncoded();
        String base64Certificate = BaseXx.getBase64((byte[])derEncodedCertificate);
        request.setAttribute("Personae", (Object)base64Certificate);
        return true;
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        X509Certificate[] clientCertChain = CertUtils.extractCert(request, this.useHeader);
        if (clientCertChain == null || clientCertChain.length < 1) {
            throw new ShiroException("Request do not contain any X509Certificate ");
        }
        return new X509AuthenticationToken(clientCertChain, this.getHost(request));
    }
}

