/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.auth.core.realm;

import fr.gouv.vitam.common.auth.core.realm.RealmUtils;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.ldap.AbstractLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.PrincipalCollection;

public class LdapRealm
extends AbstractLdapRealm {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LdapRealm.class);
    private String userDnTemplate;
    private String groupRequestFilter;
    private Map<String, String> groupRolesMap;
    private Map<String, String> roleDefs = RealmUtils.getRoleDefs();

    public void setGroupRequestFilter(String groupRequestFilter) {
        this.groupRequestFilter = groupRequestFilter;
    }

    public void setGroupRolesMap(Map<String, String> groupRolesMap) {
        this.groupRolesMap = groupRolesMap;
    }

    public void setUserDnTemplate(String userDnTemplate) {
        this.userDnTemplate = userDnTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        String userName;
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String userDn = userName = upToken.getUsername();
        if (!this.userDnTemplate.isEmpty()) {
            userDn = this.userDnTemplate.replace("{0}", userName);
        }
        LdapContext ctx = null;
        try {
            ctx = ldapContextFactory.getLdapContext(userDn, String.valueOf(upToken.getPassword()));
        }
        catch (Throwable throwable) {
            LdapUtils.closeContext(ctx);
            throw throwable;
        }
        LdapUtils.closeContext((LdapContext)ctx);
        return new SimpleAuthenticationInfo((Object)userDn, (Object)upToken.getPassword(), this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        String username = (String)this.getAvailablePrincipal(principals);
        LdapContext ldapContext = ldapContextFactory.getSystemLdapContext();
        try {
            AuthorizationInfo authorizationInfo = this.getRoleNamesForUser(username, ldapContext);
            return authorizationInfo;
        }
        finally {
            LdapUtils.closeContext((LdapContext)ldapContext);
        }
    }

    private AuthorizationInfo getRoleNamesForUser(String userName, LdapContext ldapContext) throws NamingException {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        Object[] searchArguments = new Object[]{userName};
        NamingEnumeration<SearchResult> answer = ldapContext.search(this.searchBase, this.groupRequestFilter, searchArguments, searchCtls);
        while (answer.hasMoreElements()) {
            String fullName;
            String roleForGroup;
            SearchResult sr = answer.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrieving group names for user [" + sr.getName() + "]");
            }
            if ((roleForGroup = this.getRoleNamesForGroups(fullName = sr.getNameInNamespace())) == null) continue;
            roleNames.add(roleForGroup);
        }
        SimpleAuthorizationInfo authInfo = new SimpleAuthorizationInfo(roleNames);
        Set<Permission> permissionsSet = RealmUtils.getPermissionsSet(this.roleDefs, roleNames);
        authInfo.setObjectPermissions(permissionsSet);
        return authInfo;
    }

    private String getRoleNamesForGroups(String groupName) {
        return this.groupRolesMap.get(groupName);
    }
}

