/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.auth.core.authc;

import fr.gouv.vitam.common.auth.core.authc.AbstractX509CredentialsMatcher;
import fr.gouv.vitam.common.auth.core.authc.X509AuthenticationInfo;
import fr.gouv.vitam.common.auth.core.authc.X509AuthenticationToken;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.security.cert.CertificateEncodingException;
import org.apache.shiro.crypto.hash.Sha256Hash;

public class X509CredentialsSha256Matcher
extends AbstractX509CredentialsMatcher {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(X509CredentialsSha256Matcher.class);

    @Override
    public boolean doX509CredentialsMatch(X509AuthenticationToken token, X509AuthenticationInfo info) {
        try {
            String clientCertSha256 = new Sha256Hash((Object)token.getX509Certificate().getEncoded()).toHex();
            String subjectCertSha256 = new Sha256Hash((Object)info.getX509Certificate().getEncoded()).toHex();
            boolean match = clientCertSha256.equals(subjectCertSha256);
            if (match) {
                LOGGER.debug("Client certificate Sha256 hash match the one provided by the Realm, will return true");
            } else {
                LOGGER.debug("Client certificate Sha256 hash ({}) do not match the one provided by the Realm ({}), will return false", (Object)clientCertSha256, (Object)subjectCertSha256);
            }
            return match;
        }
        catch (CertificateEncodingException ex) {
            LOGGER.debug("Unable to do credentials matching", (Throwable)ex);
            return false;
        }
    }
}

