/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.auth.core.authc;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.HostAuthenticationToken;

public class X509AuthenticationToken
implements AuthenticationToken,
HostAuthenticationToken {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(X509AuthenticationToken.class);
    private static final long serialVersionUID = 1L;
    private final X509Certificate certificate;
    private final X509Certificate[] certChain;
    private final X500Principal subjectDN;
    private final X500Principal issuerDN;
    private final String hexSerialNumber;
    private final String host;

    public X509AuthenticationToken(X509Certificate[] clientCertChain, String host) {
        if (clientCertChain == null || clientCertChain.length < 1) {
            throw new IllegalArgumentException("No certificate in the chain");
        }
        this.certChain = clientCertChain;
        this.certificate = this.certChain[0];
        this.subjectDN = this.certificate.getSubjectX500Principal();
        this.issuerDN = this.certificate.getIssuerX500Principal();
        this.hexSerialNumber = this.certificate.getSerialNumber().toString(16);
        this.host = host;
    }

    public X509AuthenticationToken(X500Principal clientSubjectDN, X500Principal clientIssuerDN, String clientHexSerialNumber, String host) {
        this.certificate = null;
        this.certChain = new X509Certificate[0];
        this.subjectDN = clientSubjectDN;
        this.issuerDN = clientIssuerDN;
        this.hexSerialNumber = clientHexSerialNumber;
        this.host = host;
    }

    public X509Certificate getX509Certificate() {
        return this.certificate;
    }

    public CertSelector getX509CertSelector() {
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setCertificate(this.certificate);
        return certSelector;
    }

    public CertStore getX509CertChainStore() {
        try {
            CollectionCertStoreParameters params = new CollectionCertStoreParameters(Arrays.asList(this.certChain));
            return CertStore.getInstance("CERTIFICATE/COLLECTION", (CertStoreParameters)params, "BC");
        }
        catch (NoSuchProviderException e) {
            LOGGER.error("Bouncy Castle is not loaded", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error("This type of Certstore is unknown (CERTIFICATE/COLLECTION)", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("algorithm of the certificate unknown", (Throwable)e);
        }
        return null;
    }

    public X500Principal getSubjectDN() {
        return this.subjectDN;
    }

    public X500Principal getIssuerDN() {
        return this.issuerDN;
    }

    public String getHexSerialNumber() {
        return this.hexSerialNumber;
    }

    public Object getPrincipal() {
        return this.subjectDN;
    }

    public Object getCredentials() {
        return null;
    }

    public String getHost() {
        return this.host;
    }
}

