/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import com.google.common.base.Strings;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.security.SafeFileChecker;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;

public final class FileUtil {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FileUtil.class);
    private static final String FILE_CANT_BE_DELETED = "File could not be deleted: ";

    private FileUtil() {
    }

    public static final String readFile(String filename) throws IOException {
        File file = new File(filename);
        return FileUtil.readFile(file);
    }

    public static final String readFile(File file) throws IOException {
        String result = "";
        if (file != null && file.canRead()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                result = FileUtil.readInputStreamLimited(inputStream, Integer.MAX_VALUE);
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                throw e;
            }
        }
        return result;
    }

    public static final String readPartialFile(File file, int limit) throws IOException {
        String result = "";
        if (file != null && file.canRead() && limit > 0) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                result = FileUtil.readInputStreamLimited(inputStream, limit);
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                throw e;
            }
        }
        return result;
    }

    private static final boolean delereRecursiveInternal(File dir) {
        boolean status = true;
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                status &= FileUtil.delereRecursiveInternal(file);
            }
            if (file.delete()) continue;
            LOGGER.warn(FILE_CANT_BE_DELETED + file);
            status = false;
        }
        return status;
    }

    public static final boolean deleteRecursive(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            if (!file.delete()) {
                LOGGER.warn(FILE_CANT_BE_DELETED + file);
                return false;
            }
            return true;
        }
        boolean status = FileUtil.delereRecursiveInternal(file);
        if (!file.delete()) {
            LOGGER.warn(FILE_CANT_BE_DELETED + file);
            status = false;
        }
        return status;
    }

    private static final String readInputStreamLimited(InputStream input, int limit) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(input);
             BufferedReader buffered = new BufferedReader(reader);){
            String line;
            while ((line = buffered.readLine()) != null) {
                builder.append(line).append('\n');
                if (builder.length() < limit) continue;
                break;
            }
        }
        return builder.toString();
    }

    public static final String readInputStream(InputStream input) throws IOException {
        return FileUtil.readInputStreamLimited(input, Integer.MAX_VALUE);
    }

    public static File createFileInTempDirectoryWithPathCheck(String filename, String fileExtension) throws IOException, IllegalPathException {
        String subPaths = Strings.isNullOrEmpty((String)fileExtension) ? filename : filename + fileExtension;
        SafeFileChecker.checkSafeFilePath(VitamConfiguration.getVitamTmpFolder(), subPaths);
        return File.createTempFile(filename, fileExtension, new File(VitamConfiguration.getVitamTmpFolder()));
    }

    public static String getFileCanonicalPath(String pathname) throws IOException {
        return new File(pathname).getCanonicalPath();
    }

    public static void fsyncFile(Path path) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.WRITE);){
            fileChannel.force(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File convertInputStreamToFile(InputStream stream, String filename, String extension) throws IOException, IllegalPathException {
        try {
            File file = FileUtil.createFileInTempDirectoryWithPathCheck(filename, extension);
            Files.copy(stream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file2 = file;
            return file2;
        }
        finally {
            StreamUtils.closeSilently((InputStream)stream);
        }
    }

    public static File convertInputStreamToFile(InputStream rulesStream, String filename) throws IOException, IllegalPathException {
        return FileUtil.convertInputStreamToFile(rulesStream, filename, "tmp");
    }
}

