/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.lifecycles.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.client.AbstractMockClient;
import fr.gouv.vitam.common.client.ClientMockResultHelper;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.model.processing.DistributionType;
import fr.gouv.vitam.logbook.common.client.ErrorMessage;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleObjectGroupModel;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleUnitModel;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParametersBulk;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameters;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.NotImplementedException;

class LogbookLifeCyclesClientMock
extends AbstractMockClient
implements LogbookLifeCyclesClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookLifeCyclesClientMock.class);
    private static final ServerIdentity SERVER_IDENTITY = ServerIdentity.getInstance();
    private static final String UPDATE = "UPDATE";
    private static final String CREATE = "CREATE";
    private static final String COMMIT = "COMMIT";
    private static final String ROLLBACK = "ROLLBACK";
    private static final ConcurrentMap<String, List<String>> lifeCyclesByOperation = new ConcurrentHashMap<String, List<String>>();

    LogbookLifeCyclesClientMock() {
    }

    @Override
    public void create(LogbookLifeCycleParameters parameters) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        this.logInformation(CREATE, (LogbookParameters)parameters);
    }

    @Override
    public void update(LogbookLifeCycleParameters parameters) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        this.logInformation(UPDATE, (LogbookParameters)parameters);
    }

    @Override
    public void update(LogbookLifeCycleParameters parameters, LifeCycleStatusCode lifeCycleStatusCode) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        this.logInformation(UPDATE, (LogbookParameters)parameters);
    }

    @Override
    @Deprecated
    public void commit(LogbookLifeCycleParameters parameters) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        this.logInformation(COMMIT, (LogbookParameters)parameters);
    }

    @Override
    public void rollback(LogbookLifeCycleParameters parameters) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        this.logInformation(ROLLBACK, (LogbookParameters)parameters);
    }

    private void logInformation(String operation, LogbookParameters parameters) {
        String result;
        try {
            result = JsonHandler.writeAsString((Object)parameters);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Cannot serialize parameters", (Throwable)e);
            result = "{}";
        }
        LOGGER.info(operation + ":" + result);
    }

    @Override
    public JsonNode selectUnitLifeCycleById(String id, JsonNode queryDsl) throws InvalidParseOperationException {
        LOGGER.debug("Select request with id:" + id);
        return ClientMockResultHelper.getLogbookOperation();
    }

    @Override
    public JsonNode selectUnitLifeCycleById(String id, JsonNode queryDsl, LifeCycleStatusCode lifeCycleStatus) throws InvalidParseOperationException {
        LOGGER.debug("Select request with id:" + id);
        return ClientMockResultHelper.getLogbookOperation();
    }

    @Override
    public JsonNode selectUnitLifeCycle(JsonNode queryDsl) throws InvalidParseOperationException {
        return ClientMockResultHelper.getLogbookLifecycle();
    }

    @Override
    public JsonNode getRawUnitLifeCycleById(String id) {
        throw new IllegalStateException("Stop using mocks in production");
    }

    @Override
    public List<JsonNode> getRawUnitLifeCycleByIds(List<String> ids) {
        throw new IllegalStateException("Stop using mocks in production");
    }

    @Override
    public JsonNode getRawObjectGroupLifeCycleById(String id) {
        throw new IllegalStateException("Stop using mocks in production");
    }

    @Override
    public List<JsonNode> getRawObjectGroupLifeCycleByIds(List<String> ids) {
        throw new IllegalStateException("Stop using mocks in production");
    }

    @Override
    public InputStream exportRawUnitLifecyclesByLastPersistedDate(LocalDateTime startDate, LocalDateTime endDate, int maxEntries) {
        throw new IllegalStateException("Stop using mocks in production");
    }

    @Override
    public InputStream exportRawObjectGroupLifecyclesByLastPersistedDate(LocalDateTime startDate, LocalDateTime endDate, int maxEntries) {
        throw new IllegalStateException("Stop using mocks in production");
    }

    @Override
    public JsonNode selectObjectGroupLifeCycleById(String id, JsonNode queryDsl) throws InvalidParseOperationException {
        LOGGER.debug("Select request with id:" + id);
        return ClientMockResultHelper.getLogbookOperation();
    }

    @Override
    public JsonNode selectObjectGroupLifeCycleById(String id, JsonNode queryDsl, LifeCycleStatusCode lifeCycleStatus) throws InvalidParseOperationException {
        LOGGER.debug("Select request with id:" + id);
        return ClientMockResultHelper.getLogbookOperation();
    }

    @Override
    public CloseableIterator<JsonNode> objectGroupLifeCyclesByOperationIterator(String operationId, LifeCycleStatusCode lifeCycleStatus, JsonNode query) {
        throw new NotImplementedException("Unsupported mock");
    }

    @Override
    public CloseableIterator<JsonNode> unitLifeCyclesByOperationIterator(String operationId, LifeCycleStatusCode lifeCycleStatus, JsonNode query) {
        throw new NotImplementedException("Unsupported mock");
    }

    private void bulkCreate(String eventIdProc, Iterable<LogbookLifeCycleParameters> queue) throws LogbookClientBadRequestException {
        if (queue != null) {
            Iterator<LogbookLifeCycleParameters> iterator = queue.iterator();
            if (iterator.hasNext()) {
                this.logInformation(CREATE, (LogbookParameters)iterator.next());
                while (iterator.hasNext()) {
                    this.logInformation(UPDATE, (LogbookParameters)iterator.next());
                }
            }
        } else {
            LOGGER.error(eventIdProc + " " + ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
            throw new LogbookClientBadRequestException(ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
        }
    }

    private void bulkUpdate(String eventIdProc, Iterable<? extends LogbookLifeCycleParameters> queue) throws LogbookClientBadRequestException {
        if (queue != null) {
            for (LogbookLifeCycleParameters logbookLifeCycleParameters : queue) {
                this.logInformation(UPDATE, (LogbookParameters)logbookLifeCycleParameters);
            }
        } else {
            LOGGER.error(eventIdProc + " " + ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
            throw new LogbookClientBadRequestException(ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
        }
    }

    @Override
    public void bulkCreateUnit(String eventIdProc, Iterable<LogbookLifeCycleParameters> queue) throws LogbookClientBadRequestException {
        this.bulkCreate(eventIdProc, queue);
    }

    @Override
    public void bulkUpdateUnit(String eventIdProc, Iterable<? extends LogbookLifeCycleParameters> queue) throws LogbookClientBadRequestException {
        this.bulkUpdate(eventIdProc, queue);
    }

    @Override
    public void bulkCreateObjectGroup(String eventIdProc, Iterable<LogbookLifeCycleParameters> queue) throws LogbookClientBadRequestException {
        this.bulkCreate(eventIdProc, queue);
    }

    @Override
    public void bulkUpdateObjectGroup(String eventIdProc, Iterable<? extends LogbookLifeCycleParameters> queue) throws LogbookClientBadRequestException {
        this.bulkUpdate(eventIdProc, queue);
    }

    @Override
    public void commitUnit(String operationId, String unitId) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        this.commitObject(operationId, unitId);
    }

    @Override
    public void commitObjectGroup(String operationId, String objectGroupId) {
        this.commitObject(operationId, objectGroupId);
    }

    private void commitObject(String operationId, String unitId) {
        if (!lifeCyclesByOperation.containsKey(operationId)) {
            ArrayList<String> objectList = new ArrayList<String>();
            objectList.add(unitId);
            lifeCyclesByOperation.put(operationId, objectList);
        } else if (!((List)lifeCyclesByOperation.get(operationId)).contains(unitId)) {
            ((List)lifeCyclesByOperation.get(operationId)).add(unitId);
        }
    }

    @Override
    public void rollBackUnitsByOperation(String operationId) throws LogbookClientNotFoundException {
        this.rollBackObjectByOperation(operationId);
    }

    @Override
    public void rollBackObjectGroupsByOperation(String operationId) throws LogbookClientNotFoundException {
        this.rollBackObjectByOperation(operationId);
    }

    private void rollBackObjectByOperation(String operationId) throws LogbookClientNotFoundException {
        if (!lifeCyclesByOperation.containsKey(operationId)) {
            throw new LogbookClientNotFoundException("Operation not found");
        }
        lifeCyclesByOperation.remove(operationId);
    }

    @Override
    public LifeCycleStatusCode getUnitLifeCycleStatus(String unitId) {
        return this.getObjectLifeCycleStatus(unitId);
    }

    @Override
    public LifeCycleStatusCode getObjectGroupLifeCycleStatus(String objectGroupId) {
        return this.getObjectLifeCycleStatus(objectGroupId);
    }

    private LifeCycleStatusCode getObjectLifeCycleStatus(String objectId) {
        for (List objectList : lifeCyclesByOperation.values()) {
            if (!objectList.contains(objectId)) continue;
            return LifeCycleStatusCode.LIFE_CYCLE_COMMITTED;
        }
        return null;
    }

    @Override
    public JsonNode selectObjectGroupLifeCycle(JsonNode queryDsl) throws InvalidParseOperationException {
        return ClientMockResultHelper.getLogbookLifecycle();
    }

    @Override
    public JsonNode selectObjectGroupLifeCycle(JsonNode queryDsl, LifeCycleStatusCode lifeCycleStatus) throws InvalidParseOperationException {
        return ClientMockResultHelper.getLogbookLifecycle();
    }

    @Override
    public void bulkObjectGroup(String eventIdProc, List<LogbookLifeCycleObjectGroupModel> logbookLifeCycleModels) {
    }

    @Override
    public void bulkUnit(String eventIdProc, List<LogbookLifeCycleUnitModel> logbookLifeCycleModels) throws LogbookClientAlreadyExistsException, LogbookClientBadRequestException, LogbookClientServerException {
    }

    @Override
    public void createRawbulkObjectgrouplifecycles(List<JsonNode> logbookLifeCycleRaws) {
    }

    @Override
    public void createRawbulkUnitlifecycles(List<JsonNode> logbookLifeCycleRaws) {
    }

    @Override
    public void deleteLifecycleUnitsBulk(Collection<String> listIds) {
        throw new IllegalArgumentException("Stop mocking in production ");
    }

    @Override
    public void deleteLifecycleObjectGroupBulk(Collection<String> listIds) {
        throw new IllegalArgumentException("Stop mocking in production ");
    }

    @Override
    public void bulkLifeCycleTemporary(String operationId, DistributionType type, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) {
    }

    @Override
    public void bulkLifeCycle(String operationId, DistributionType type, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) {
    }

    @Override
    public LogbookOperation findLastLifecycleTraceabilityOperation(String eventType) {
        throw new IllegalArgumentException("Stop mocking in production ");
    }
}

