/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.ValidationErrorMessage;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.JsonTypeName;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.meta.ValidatorEngine;
import java.util.Map;
import java.util.function.Consumer;

public class TypeChoiceFormat
extends Format {
    private Map<JsonTypeName, Format> choices;

    @Override
    protected void resolve(Schema schema) {
        for (Format format : this.choices.values()) {
            format.setReportingType(this);
        }
    }

    public void setChoices(Map<JsonTypeName, Format> choices) {
        this.choices = choices;
    }

    @Override
    public void validate(JsonNode node, Consumer<String> fieldReport, ValidatorEngine validator) {
        JsonTypeName typeName = JsonTypeName.fromJsonNodeType(node.getNodeType());
        Format choosen = this.choices.get((Object)typeName);
        if (choosen == null) {
            validator.reportError(this, node, ValidationErrorMessage.Code.NO_VIABLE_ALTERNATIVE, typeName.toString());
        } else {
            validator.validate(choosen, node, fieldReport);
        }
    }

    @Override
    public void walk(Consumer<Format> consumer) {
        consumer.accept(this);
        for (Format format : this.choices.values()) {
            format.walk(consumer);
        }
    }

    @Override
    public String debugInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean notFirst = false;
        for (Map.Entry<JsonTypeName, Format> entry : this.choices.entrySet()) {
            if (notFirst) {
                builder.append("}|{");
            }
            builder.append((Object)entry.getKey());
            builder.append("-> ");
            builder.append(entry.getValue().debugInfo());
            notFirst = true;
        }
        builder.append("}");
        return builder.toString();
    }
}

