/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.ValidationErrorMessage;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.meta.ValidatorEngine;
import java.util.Map;
import java.util.function.Consumer;

public class KeyChoiceFormat
extends Format {
    private Map<String, Format> choices;

    public KeyChoiceFormat() {
        this.setMin(1);
    }

    @Override
    protected void resolve(Schema schema) {
        for (Map.Entry<String, Format> entry : this.choices.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
    }

    public Map<String, Format> getChoices() {
        return this.choices;
    }

    public void setChoices(Map<String, Format> choices) {
        this.choices = choices;
    }

    @Override
    public void validate(JsonNode node, Consumer<String> fieldReport, ValidatorEngine validator) {
        if (!node.isObject()) {
            validator.reportError(this, node, ValidationErrorMessage.Code.WRONG_JSON_TYPE, node.getNodeType().name());
            return;
        }
        for (Map.Entry<String, Format> entry : this.choices.entrySet()) {
            String name = entry.getKey();
            Format subProperty = entry.getValue();
            JsonNode value = null;
            value = name.equals("$subobject") && node.get(name) != null && node.get(name).fields().hasNext() ? (JsonNode)((Map.Entry)node.get(name).fields().next()).getValue() : node.get(name);
            if (value == null) continue;
            fieldReport.accept(name);
            validator.pushContext(name);
            validator.validate(subProperty, value, null);
            validator.popContext();
            return;
        }
    }

    @Override
    public void walk(Consumer<Format> consumer) {
        consumer.accept(this);
        for (Format property : this.choices.values()) {
            property.walk(consumer);
        }
    }

    @Override
    public String debugInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean notFirst = false;
        for (Map.Entry<String, Format> entry : this.choices.entrySet()) {
            if (notFirst) {
                builder.append("}|{");
            }
            builder.append(entry.getKey());
            builder.append(": ...");
            notFirst = true;
        }
        builder.append("}");
        return builder.toString();
    }
}

