/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ValidationErrorMessage {
    private JsonNode node;
    private Format property;
    private Code code;
    private String message;
    private List<Object> context;

    public ValidationErrorMessage(JsonNode node, Format property, Code code, String message, List<Object> context) {
        this.node = node;
        this.property = property;
        this.code = code;
        this.message = message;
        this.context = context;
    }

    public String toString() {
        String name = !StringUtils.isAllUpperCase((CharSequence)this.property.getName()) || this.context.isEmpty() ? this.property.getName() : this.context.get(this.context.size() - 1).toString();
        return "Validating " + name + ": " + this.property.getReportingType().debugInfo() + " ~ " + this.code + ValidationErrorMessage.combineSeparator(": ", this.message) + ValidationErrorMessage.combineSeparator(" ~ hint: ", this.property.getHint()) + " ~ found json: " + this.node + " ~ path: " + this.context;
    }

    private static String combineSeparator(String sep, String string) {
        if (string != null) {
            return sep + string;
        }
        return "";
    }

    public static enum Code {
        WRONG_JSON_TYPE,
        MANDATORY,
        ELEMENT_TOO_SHORT,
        ELEMENT_TOO_LONG,
        INVALID_JSON_FIELD,
        NO_VIABLE_ALTERNATIVE,
        INVALID_VALUE;

    }
}

