/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.common.service;

import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.security.internal.common.exception.PersonalCertificateException;
import fr.gouv.vitam.security.internal.common.service.X509PKIUtil;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;

public class ParsedCertificate {
    private static final int MAX_CERTIFICATE_LOG_LENGTH = 10240;
    private static final DigestType digestType = DigestType.SHA256;
    private final X509Certificate x509Certificate;
    private final byte[] rawCertificate;
    private final String certificateHash;

    public ParsedCertificate(X509Certificate x509Certificate, byte[] rawCertificate, String certificateHash) {
        this.x509Certificate = x509Certificate;
        this.rawCertificate = rawCertificate;
        this.certificateHash = certificateHash;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public byte[] getRawCertificate() {
        return this.rawCertificate;
    }

    public String getCertificateHash() {
        return this.certificateHash;
    }

    public static ParsedCertificate parseCertificate(byte[] certificate) throws PersonalCertificateException {
        try {
            X509Certificate x509certificate = X509PKIUtil.parseX509Certificate(certificate);
            byte[] rawCertificate = x509certificate.getEncoded();
            String certificateHash = ParsedCertificate.getCertificateHash(rawCertificate);
            return new ParsedCertificate(x509certificate, rawCertificate, certificateHash);
        }
        catch (CertificateException ex) {
            throw new PersonalCertificateException("Could not parse certificate. " + ParsedCertificate.toCertificateHexString(certificate), ex);
        }
    }

    private static String getCertificateHash(byte[] rawDerEncodedCertificate) {
        Digest digest = new Digest(digestType).update(rawDerEncodedCertificate);
        return digest.digestHex();
    }

    public static String toCertificateHexString(byte[] certificate) {
        if (certificate.length > 10240) {
            byte[] truncatedCertificateToLog = Arrays.copyOf(certificate, 10240);
            return Hex.encodeHexString((byte[])truncatedCertificateToLog) + "... [truncated]";
        }
        return Hex.encodeHexString((byte[])certificate);
    }
}

